//+------------------------------------------------------------------+
//|                                              Ind-TD-DeMark-3.mq5 |
//|                                         forexsynthetics.com       |
//|                                   https://forexsynthetics.com     |
//+------------------------------------------------------------------+
#property copyright "forexsynthetics.com"
#property link      "https://forexsynthetics.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   2
//---- plot TD_High
#property indicator_label1  "TD High"
#property indicator_type1   DRAW_ARROW
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//---- plot TD_Low
#property indicator_label2  "TD Low"
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrBlue
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1

//---- input parameters
input int       BackSteps=0;
input int       ShowingSteps=1;
input bool      FractalAsTD=false;
input bool      Commen=true;
input bool      TD=true;
input bool      TrendLine=true;
input bool      HorizontLine=true;
input bool      TakeProf=true;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
   //---- indicator buffers mapping
   SetIndexBuffer(0,ExtMapBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtMapBuffer2,INDICATOR_DATA);
   
   //---- setting arrow codes
   PlotIndexSetInteger(0,PLOT_ARROW,217);
   PlotIndexSetInteger(1,PLOT_ARROW,218);
   
   //---- setting empty value
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
   //---- delete old objects
   for(int i=1;i<=10;i++)
   {
      ObjectDelete(0,"HHL_"+IntegerToString(i));
      ObjectDelete(0,"HL_"+IntegerToString(i));
      ObjectDelete(0,"HLL_"+IntegerToString(i));
      ObjectDelete(0,"LL_"+IntegerToString(i));
      ObjectDelete(0,"HC1_"+IntegerToString(i));
      ObjectDelete(0,"HC2_"+IntegerToString(i));
      ObjectDelete(0,"HC3_"+IntegerToString(i));
      ObjectDelete(0,"LC1_"+IntegerToString(i));
      ObjectDelete(0,"LC2_"+IntegerToString(i));
      ObjectDelete(0,"LC3_"+IntegerToString(i));
   }
   
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   //---- delete objects
   for(int i=1;i<=10;i++)
   {
      ObjectDelete(0,"HHL_"+IntegerToString(i));
      ObjectDelete(0,"HL_"+IntegerToString(i));
      ObjectDelete(0,"HLL_"+IntegerToString(i));
      ObjectDelete(0,"LL_"+IntegerToString(i));
      ObjectDelete(0,"HC1_"+IntegerToString(i));
      ObjectDelete(0,"HC2_"+IntegerToString(i));
      ObjectDelete(0,"HC3_"+IntegerToString(i));
      ObjectDelete(0,"LC1_"+IntegerToString(i));
      ObjectDelete(0,"LC2_"+IntegerToString(i));
      ObjectDelete(0,"LC3_"+IntegerToString(i));
   }
   ChartRedraw();
}

//+------------------------------------------------------------------+
//| Set TD Points                                                     |
//+------------------------------------------------------------------+
void SetTDPoint(int B)
{
   int shift;
   if(FractalAsTD==false)
   {
      for(shift=B;shift>1;shift--)
      {
         if(iHigh(NULL,0,shift+1)<iHigh(NULL,0,shift) && 
            iHigh(NULL,0,shift-1)<iHigh(NULL,0,shift) && 
            iClose(NULL,0,shift+2)<iHigh(NULL,0,shift))
            ExtMapBuffer1[shift]=iHigh(NULL,0,shift);
         else 
            ExtMapBuffer1[shift]=0;
            
         if(iLow(NULL,0,shift+1)>iLow(NULL,0,shift) && 
            iLow(NULL,0,shift-1)>iLow(NULL,0,shift) && 
            iClose(NULL,0,shift+2)>iLow(NULL,0,shift))
            ExtMapBuffer2[shift]=iLow(NULL,0,shift);
         else 
            ExtMapBuffer2[shift]=0;
      }
      ExtMapBuffer1[0]=0;
      ExtMapBuffer2[0]=0;
      ExtMapBuffer1[1]=0;
      ExtMapBuffer2[1]=0;
   }
   else
   {
      for(shift=B;shift>3;shift--)
      {
         if(iHigh(NULL,0,shift+1)<=iHigh(NULL,0,shift) && 
            iHigh(NULL,0,shift-1)<iHigh(NULL,0,shift) && 
            iHigh(NULL,0,shift+2)<=iHigh(NULL,0,shift) && 
            iHigh(NULL,0,shift-2)<iHigh(NULL,0,shift))
            ExtMapBuffer1[shift]=iHigh(NULL,0,shift);
         else 
            ExtMapBuffer1[shift]=0;
            
         if(iLow(NULL,0,shift+1)>=iLow(NULL,0,shift) && 
            iLow(NULL,0,shift-1)>iLow(NULL,0,shift) && 
            iLow(NULL,0,shift+2)>=iLow(NULL,0,shift) && 
            iLow(NULL,0,shift-2)>iLow(NULL,0,shift))
            ExtMapBuffer2[shift]=iLow(NULL,0,shift);
         else 
            ExtMapBuffer2[shift]=0;
      }
      ExtMapBuffer1[0]=0;
      ExtMapBuffer2[0]=0;
      ExtMapBuffer1[1]=0;
      ExtMapBuffer2[1]=0;
      ExtMapBuffer1[2]=0;
      ExtMapBuffer2[2]=0;
   }
}

//+------------------------------------------------------------------+
//| Get High TD                                                       |
//+------------------------------------------------------------------+
int GetHighTD(int P)
{
   int i=0,j=0;
   while(j<P)
   {
      i++;
      while(ExtMapBuffer1[i]==0)
      {
         i++;
         if(i>Bars(NULL,0)-2)
            return(-1);
      }
      j++;
   }
   return(i);
}

//+------------------------------------------------------------------+
//| Get Next High TD                                                  |
//+------------------------------------------------------------------+
int GetNextHighTD(int P)
{
   int i=P+1;
   while(ExtMapBuffer1[i]<=iHigh(NULL,0,P))
   {
      i++;
      if(i>Bars(NULL,0)-2)
         return(-1);
   }
   return(i);
}

//+------------------------------------------------------------------+
//| Get Low TD                                                        |
//+------------------------------------------------------------------+
int GetLowTD(int P)
{
   int i=0,j=0;
   while(j<P)
   {
      i++;
      while(ExtMapBuffer2[i]==0)
      {
         i++;
         if(i>Bars(NULL,0)-2)
            return(-1);
      }
      j++;
   }
   return(i);
}

//+------------------------------------------------------------------+
//| Get Next Low TD                                                   |
//+------------------------------------------------------------------+
int GetNextLowTD(int P)
{
   int i=P+1;
   while(ExtMapBuffer2[i]>=iLow(NULL,0,P) || ExtMapBuffer2[i]==0)
   {
      i++;
      if(i>Bars(NULL,0)-2)
         return(-1);
   }
   return(i);
}

//+------------------------------------------------------------------+
//| Trend Line High TD                                                |
//+------------------------------------------------------------------+
void TrendLineHighTD(int H1,int H2,int Step,color Col)
{
   string name="HL_"+IntegerToString(Step);
   ObjectSetInteger(0,name,OBJPROP_TIME,0,iTime(NULL,0,H2));
   ObjectSetInteger(0,name,OBJPROP_TIME,1,iTime(NULL,0,H1));
   ObjectSetDouble(0,name,OBJPROP_PRICE,0,iHigh(NULL,0,H2));
   ObjectSetDouble(0,name,OBJPROP_PRICE,1,iHigh(NULL,0,H1));
   ObjectSetInteger(0,name,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name,OBJPROP_RAY_RIGHT,true);
   if(Step==1)
      ObjectSetInteger(0,name,OBJPROP_WIDTH,2);
   else
      ObjectSetInteger(0,name,OBJPROP_WIDTH,1);
}

//+------------------------------------------------------------------+
//| Trend Line Low TD                                                 |
//+------------------------------------------------------------------+
void TrendLineLowTD(int L1,int L2,int Step,color Col)
{
   string name="LL_"+IntegerToString(Step);
   ObjectSetInteger(0,name,OBJPROP_TIME,0,iTime(NULL,0,L2));
   ObjectSetInteger(0,name,OBJPROP_TIME,1,iTime(NULL,0,L1));
   ObjectSetDouble(0,name,OBJPROP_PRICE,0,iLow(NULL,0,L2));
   ObjectSetDouble(0,name,OBJPROP_PRICE,1,iLow(NULL,0,L1));
   ObjectSetInteger(0,name,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name,OBJPROP_RAY_RIGHT,true);
   if(Step==1)
      ObjectSetInteger(0,name,OBJPROP_WIDTH,2);
   else
      ObjectSetInteger(0,name,OBJPROP_WIDTH,1);
}

//+------------------------------------------------------------------+
//| Horizontal Line High TD                                           |
//+------------------------------------------------------------------+
void HorizontLineHighTD(int H1,int H2,int Step,ENUM_LINE_STYLE St,color Col)
{
   string name="HHL_"+IntegerToString(Step);
   double price=iHigh(NULL,0,H2)-(iHigh(NULL,0,H2)-iHigh(NULL,0,H1))/(H2-H1)*H2;
   ObjectSetDouble(0,name,OBJPROP_PRICE,0,price);
   ObjectSetInteger(0,name,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name,OBJPROP_COLOR,Col);
}

//+------------------------------------------------------------------+
//| Horizontal Line Low TD                                            |
//+------------------------------------------------------------------+
void HorizontLineLowTD(int L1,int L2,int Step,ENUM_LINE_STYLE St,color Col)
{
   string name="HLL_"+IntegerToString(Step);
   double price=iLow(NULL,0,L2)+(iLow(NULL,0,L1)-iLow(NULL,0,L2))/(L2-L1)*L2;
   ObjectSetDouble(0,name,OBJPROP_PRICE,0,price);
   ObjectSetInteger(0,name,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name,OBJPROP_COLOR,Col);
}

//+------------------------------------------------------------------+
//| Take Profit High TD                                               |
//+------------------------------------------------------------------+
string TakeProfitHighTD(int H1,int H2,int Step,color Col)
{
   int i,ii,j=0;
   string Comm="";
   double kH,HC1,HC2,HC3,k;
   ENUM_LINE_STYLE St;
   
   kH=(iHigh(NULL,0,H2)-iHigh(NULL,0,H1))/(H2-H1);
   while(NormalizeDouble(_Point,j)==0) j++;
   
   k=0;
   for(i=H1;i>0;i--)
   {
      if(iClose(NULL,0,i)>iHigh(NULL,0,H2)-kH*(H2-i))
      {
         k=iHigh(NULL,0,H2)-kH*(H2-i);
         break;
      }
   }
   
   if(k>0)
   {
      Comm=Comm+"UTD_Line ("+DoubleToString(iHigh(NULL,0,H2)-kH*H2,j)+") broken at "+DoubleToString(k,j)+", upside targets:\n";
      ii=iLowest(NULL,0,MODE_LOW,H2,i);
      HC1=iHigh(NULL,0,H2)-kH*(H2-ii)-iLow(NULL,0,ii);
      HC2=iHigh(NULL,0,H2)-kH*(H2-ii)-iClose(NULL,0,ii);
      ii=iLowest(NULL,0,MODE_CLOSE,H2,i);
      HC3=iHigh(NULL,0,H2)-kH*(H2-ii)-iClose(NULL,0,ii);
      St=STYLE_SOLID;
   }
   else
   {
      k=iHigh(NULL,0,H2)-kH*H2;
      Comm=Comm+"UTD_Line ("+DoubleToString(k,j)+"), expected upside targets if broken:\n";
      ii=iLowest(NULL,0,MODE_LOW,H2,0);
      HC1=iHigh(NULL,0,H2)-kH*(H2-ii)-iLow(NULL,0,ii);
      HC2=iHigh(NULL,0,H2)-kH*(H2-ii)-iClose(NULL,0,ii);
      ii=iLowest(NULL,0,MODE_CLOSE,H2,0);
      HC3=iHigh(NULL,0,H2)-kH*(H2-ii)-iClose(NULL,0,ii);
      St=STYLE_DASHDOT;
   }
   
   ObjectSetInteger(0,"HL_"+IntegerToString(Step),OBJPROP_STYLE,St);
   
   Comm=Comm+"T1="+DoubleToString(HC1+k,j)+" ("+DoubleToString(HC1/_Point,0)+"p.)";
   Comm=Comm+" T2="+DoubleToString(HC2+k,j)+" ("+DoubleToString(HC2/_Point,0)+"p.)";
   Comm=Comm+" T3="+DoubleToString(HC3+k,j)+" ("+DoubleToString(HC3/_Point,0)+"p.)\n";
   
   //---- Create target lines
   string name1="HC1_"+IntegerToString(Step);
   ObjectSetInteger(0,name1,OBJPROP_TIME,0,iTime(NULL,0,H1));
   ObjectSetInteger(0,name1,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name1,OBJPROP_PRICE,0,HC1+k);
   ObjectSetDouble(0,name1,OBJPROP_PRICE,1,HC1+k);
   ObjectSetInteger(0,name1,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name1,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name1,OBJPROP_RAY_RIGHT,true);
   
   string name2="HC2_"+IntegerToString(Step);
   ObjectSetInteger(0,name2,OBJPROP_TIME,0,iTime(NULL,0,H1));
   ObjectSetInteger(0,name2,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name2,OBJPROP_PRICE,0,HC2+k);
   ObjectSetDouble(0,name2,OBJPROP_PRICE,1,HC2+k);
   ObjectSetInteger(0,name2,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name2,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name2,OBJPROP_RAY_RIGHT,true);
   
   string name3="HC3_"+IntegerToString(Step);
   ObjectSetInteger(0,name3,OBJPROP_TIME,0,iTime(NULL,0,H1));
   ObjectSetInteger(0,name3,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name3,OBJPROP_PRICE,0,HC3+k);
   ObjectSetDouble(0,name3,OBJPROP_PRICE,1,HC3+k);
   ObjectSetInteger(0,name3,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name3,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name3,OBJPROP_RAY_RIGHT,true);
   
   if(Step==1)
   {
      ObjectSetInteger(0,name1,OBJPROP_WIDTH,2);
      ObjectSetInteger(0,name2,OBJPROP_WIDTH,2);
      ObjectSetInteger(0,name3,OBJPROP_WIDTH,2);
   }
   else
   {
      ObjectSetInteger(0,name1,OBJPROP_WIDTH,1);
      ObjectSetInteger(0,name2,OBJPROP_WIDTH,1);
      ObjectSetInteger(0,name3,OBJPROP_WIDTH,1);
   }
   
   return(Comm);
}

//+------------------------------------------------------------------+
//| Take Profit Low TD                                                |
//+------------------------------------------------------------------+
string TakeProfitLowTD(int L1,int L2,int Step,color Col)
{
   int i,ii,j=0;
   string Comm="";
   double kL,LC1,LC2,LC3,k;
   ENUM_LINE_STYLE St;
   
   kL=(iLow(NULL,0,L1)-iLow(NULL,0,L2))/(L2-L1);
   while(NormalizeDouble(_Point,j)==0) j++;
   
   k=0;
   for(i=L1;i>0;i--)
   {
      if(iClose(NULL,0,i)<iLow(NULL,0,L2)+kL*(L2-i))
      {
         k=iLow(NULL,0,L2)+kL*(L2-i);
         break;
      }
   }
   
   if(k>0)
   {
      Comm=Comm+"LTD_Line ("+DoubleToString(iLow(NULL,0,L2)+kL*L2,j)+") broken at "+DoubleToString(k,j)+", downside targets:\n";
      ii=iHighest(NULL,0,MODE_HIGH,L2,i);
      LC1=iHigh(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      LC2=iClose(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      ii=iHighest(NULL,0,MODE_CLOSE,L2,i);
      LC3=iClose(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      St=STYLE_SOLID;
   }
   else
   {
      k=iLow(NULL,0,L2)+kL*L2;
      Comm=Comm+"LTD_Line ("+DoubleToString(k,j)+"), expected downside targets if broken:\n";
      ii=iHighest(NULL,0,MODE_HIGH,L2,0);
      LC1=iHigh(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      LC2=iClose(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      ii=iHighest(NULL,0,MODE_CLOSE,L2,0);
      LC3=iClose(NULL,0,ii)-(iLow(NULL,0,L2)+kL*(L2-ii));
      St=STYLE_DASHDOT;
   }
   
   ObjectSetInteger(0,"LL_"+IntegerToString(Step),OBJPROP_STYLE,St);
   
   Comm=Comm+"T1="+DoubleToString(k-LC1,j)+" ("+DoubleToString(LC1/_Point,0)+"p.)";
   Comm=Comm+" T2="+DoubleToString(k-LC2,j)+" ("+DoubleToString(LC2/_Point,0)+"p.)";
   Comm=Comm+" T3="+DoubleToString(k-LC3,j)+" ("+DoubleToString(LC3/_Point,0)+"p.)\n";
   
   //---- Create target lines
   string name1="LC1_"+IntegerToString(Step);
   ObjectSetInteger(0,name1,OBJPROP_TIME,0,iTime(NULL,0,L1));
   ObjectSetInteger(0,name1,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name1,OBJPROP_PRICE,0,k-LC1);
   ObjectSetDouble(0,name1,OBJPROP_PRICE,1,k-LC1);
   ObjectSetInteger(0,name1,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name1,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name1,OBJPROP_RAY_RIGHT,true);
   
   string name2="LC2_"+IntegerToString(Step);
   ObjectSetInteger(0,name2,OBJPROP_TIME,0,iTime(NULL,0,L1));
   ObjectSetInteger(0,name2,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name2,OBJPROP_PRICE,0,k-LC2);
   ObjectSetDouble(0,name2,OBJPROP_PRICE,1,k-LC2);
   ObjectSetInteger(0,name2,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name2,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name2,OBJPROP_RAY_RIGHT,true);
   
   string name3="LC3_"+IntegerToString(Step);
   ObjectSetInteger(0,name3,OBJPROP_TIME,0,iTime(NULL,0,L1));
   ObjectSetInteger(0,name3,OBJPROP_TIME,1,iTime(NULL,0,0));
   ObjectSetDouble(0,name3,OBJPROP_PRICE,0,k-LC3);
   ObjectSetDouble(0,name3,OBJPROP_PRICE,1,k-LC3);
   ObjectSetInteger(0,name3,OBJPROP_COLOR,Col);
   ObjectSetInteger(0,name3,OBJPROP_STYLE,St);
   ObjectSetInteger(0,name3,OBJPROP_RAY_RIGHT,true);
   
   if(Step==1)
   {
      ObjectSetInteger(0,name1,OBJPROP_WIDTH,2);
      ObjectSetInteger(0,name2,OBJPROP_WIDTH,2);
      ObjectSetInteger(0,name3,OBJPROP_WIDTH,2);
   }
   else
   {
      ObjectSetInteger(0,name1,OBJPROP_WIDTH,1);
      ObjectSetInteger(0,name2,OBJPROP_WIDTH,1);
      ObjectSetInteger(0,name3,OBJPROP_WIDTH,1);
   }
   
   return(Comm);
}

//+------------------------------------------------------------------+
//| TD Main Function                                                  |
//+------------------------------------------------------------------+
string TDMain(int Step)
{
   int H1,H2,L1,L2;
   string Comm="---   STEP "+IntegerToString(Step)+"   --------------------\n";
   int j=0;
   while(NormalizeDouble(_Point,j)==0) j++;
   
   ENUM_LINE_STYLE Style;
   color Col[20];
   Col[0]=clrRed; Col[2]=clrMagenta; Col[4]=clrChocolate; Col[6]=clrGoldenrod; Col[8]=clrSlateBlue;
   Col[1]=clrBlue; Col[3]=clrDeepSkyBlue; Col[5]=clrGreen; Col[7]=clrMediumOrchid; Col[9]=clrCornflowerBlue;
   Col[10]=clrRed; Col[12]=clrMagenta; Col[14]=clrChocolate; Col[16]=clrGoldenrod; Col[18]=clrSlateBlue;
   Col[11]=clrBlue; Col[13]=clrDeepSkyBlue; Col[15]=clrGreen; Col[17]=clrMediumOrchid; Col[19]=clrCornflowerBlue;
   
   Step=Step+BackSteps;
   H1=GetHighTD(Step);
   H2=GetNextHighTD(H1);
   L1=GetLowTD(Step);
   L2=GetNextLowTD(L1);
   
   if(H1<0)
      Comm=Comm+"UTD no upper TD point on chart\n";
   else
   {
      if(H2<0)
         Comm=Comm+"UTD no TD point higher than last ("+DoubleToString(iHigh(NULL,0,H1),j)+")\n";
      else
         Comm=Comm+"UTD "+DoubleToString(iHigh(NULL,0,H2),j)+"  "+DoubleToString(iHigh(NULL,0,H1),j)+"\n";
   }
   
   if(L1<0)
      Comm=Comm+"LTD no lower TD point on chart\n";
   else
   {
      if(L2<0)
         Comm=Comm+"LTD no TD point lower than last ("+DoubleToString(iLow(NULL,0,L1),j)+")\n";
      else
         Comm=Comm+"LTD  "+DoubleToString(iLow(NULL,0,L2),j)+"  "+DoubleToString(iLow(NULL,0,L1),j)+"\n";
   }
   
   //---- Process high trend line
   if(Step==1)
      Style=STYLE_SOLID;
   else
      Style=STYLE_DOT;
      
   if(H1>0 && H2>0)
   {
      if(TrendLine==true)
      {
         ObjectCreate(0,"HL_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         TrendLineHighTD(H1,H2,Step,Col[Step*2-2]);
      }
      else
         ObjectDelete(0,"HL_"+IntegerToString(Step));
         
      if(HorizontLine==true && Step==1)
      {
         ObjectCreate(0,"HHL_"+IntegerToString(Step),OBJ_HLINE,0,0,0);
         HorizontLineHighTD(H1,H2,Step,Style,Col[Step*2-2]);
      }
      else
         ObjectDelete(0,"HHL_"+IntegerToString(Step));
         
      if(TakeProf==true)
      {
         ObjectCreate(0,"HC1_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         ObjectCreate(0,"HC2_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         ObjectCreate(0,"HC3_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         Comm=Comm+TakeProfitHighTD(H1,H2,Step,Col[Step*2-2]);
      }
      else
      {
         ObjectDelete(0,"HC1_"+IntegerToString(Step));
         ObjectDelete(0,"HC2_"+IntegerToString(Step));
         ObjectDelete(0,"HC3_"+IntegerToString(Step));
      }
   }
   
   //---- Process low trend line
   if(L1>0 && L2>0)
   {
      if(TrendLine==true)
      {
         ObjectCreate(0,"LL_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         TrendLineLowTD(L1,L2,Step,Col[Step*2-1]);
      }
      else
         ObjectDelete(0,"LL_"+IntegerToString(Step));
         
      if(HorizontLine==true && Step==1)
      {
         ObjectCreate(0,"HLL_"+IntegerToString(Step),OBJ_HLINE,0,0,0);
         HorizontLineLowTD(L1,L2,Step,Style,Col[Step*2-1]);
      }
      else
         ObjectDelete(0,"HLL_"+IntegerToString(Step));
         
      if(TakeProf==true)
      {
         ObjectCreate(0,"LC1_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         ObjectCreate(0,"LC2_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         ObjectCreate(0,"LC3_"+IntegerToString(Step),OBJ_TREND,0,0,0,0,0);
         Comm=Comm+TakeProfitLowTD(L1,L2,Step,Col[Step*2-1]);
      }
      else
      {
         ObjectDelete(0,"LC1_"+IntegerToString(Step));
         ObjectDelete(0,"LC2_"+IntegerToString(Step));
         ObjectDelete(0,"LC3_"+IntegerToString(Step));
      }
   }
   
   return(Comm);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   string Comm="";
   
   SetTDPoint(rates_total-1);
   
   if(TD==true)
   {
      PlotIndexSetInteger(0,PLOT_ARROW,217);
      PlotIndexSetInteger(1,PLOT_ARROW,218);
   }
   else
   {
      PlotIndexSetInteger(0,PLOT_ARROW,160);
      PlotIndexSetInteger(1,PLOT_ARROW,160);
   }
   
   if(ShowingSteps>10)
   {
      Comment("ShowingSteps value 0 - 10");
      return(rates_total);
   }
   
   for(int i=1;i<=ShowingSteps;i++)
      Comm=Comm+TDMain(i);
      
   Comm=Comm+"------------------------------------\nShowingSteps="+IntegerToString(ShowingSteps)+"\nBackSteps="+IntegerToString(BackSteps);
   
   if(Commen==true)
      Comment(Comm);
   else
      Comment("");
      
   return(rates_total);
}
//+------------------------------------------------------------------+
