//+------------------------------------------------------------------+
//|                                  PolynomialRegressionChannel.mq5 |
//|                                      Converted to MT5 by Jackie  |
//|                                      https://forexsynthetics.com |
//+------------------------------------------------------------------+
#property copyright "Converted to MT5 by forexsynthetics"
#property link      "https://forexsynthetics.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_plots   3

//--- Plot settings
#property indicator_label1  "Regression Line"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrLimeGreen
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

#property indicator_label2  "Upper Channel"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrGold
#property indicator_style2  STYLE_SOLID
#property indicator_width2  2

#property indicator_label3  "Lower Channel"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrGold
#property indicator_style3  STYLE_SOLID
#property indicator_width3  2

//--- Input parameters
input int    degree = 3;        // Polynomial Degree
input double kstd   = 2.0;      // Standard Deviation Multiplier
input int    bars   = 250;      // Number of Bars
input int    shift  = 0;        // Horizontal Shift

//--- Indicator buffers
double fx[];
double sqh[];
double sql[];

//--- Global arrays
double ai[10][10];
double b[10];
double x[10];
double sx[20];

//--- Global variables
double sum; 
int ip, p, n, f;
double qq, mm, tt;
int ii, jj, kk, ll, nn;
double sq;
int i0 = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
   //--- Indicator buffers mapping
   SetIndexBuffer(0, fx, INDICATOR_DATA);
   SetIndexBuffer(1, sqh, INDICATOR_DATA);
   SetIndexBuffer(2, sql, INDICATOR_DATA);
   
   //--- Set index shift
   PlotIndexSetInteger(0, PLOT_SHIFT, shift);
   PlotIndexSetInteger(1, PLOT_SHIFT, shift);
   PlotIndexSetInteger(2, PLOT_SHIFT, shift);
   
   //--- Set empty value
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, 0.0);
   
   //--- Set indicator short name
   string short_name = StringFormat("Polynomial Regression Channel(%d,%g,%d)", degree, kstd, bars);
   IndicatorSetString(INDICATOR_SHORTNAME, short_name);
   
   //--- Set digits
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);
   
   //--- Set arrays as series
   ArraySetAsSeries(fx, true);
   ArraySetAsSeries(sqh, true);
   ArraySetAsSeries(sql, true);
   
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   if(rates_total < bars) return(0);
   
   //--- Set arrays as series
   ArraySetAsSeries(close, true);
   
   //--- Calculate indicator
   ip = bars;
   p = ip;
   sx[1] = p + 1;
   nn = degree + 1;
   
   //--- Set drawing begin
   int begin = rates_total - p - 1;
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, begin);
   PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, begin);
   PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, begin);
   
   //--- Calculate sx array
   for(int mi = 1; mi <= nn * 2 - 2; mi++)
   {
      sum = 0;
      for(n = i0; n <= i0 + p; n++)
      {
         sum += MathPow(n, mi);
      }
      sx[mi + 1] = sum;
   }
   
   //--- Calculate syx
   for(int mi = 1; mi <= nn; mi++)
   {
      sum = 0.00000;
      for(n = i0; n <= i0 + p; n++)
      {
         if(mi == 1) 
            sum += close[n];
         else 
            sum += close[n] * MathPow(n, mi - 1);
      }
      b[mi] = sum;
   }
   
   //--- Build Matrix
   for(jj = 1; jj <= nn; jj++)
   {
      for(ii = 1; ii <= nn; ii++)
      {
         kk = ii + jj - 1;
         ai[ii][jj] = sx[kk];
      }
   }
   
   //--- Gauss elimination
   for(kk = 1; kk <= nn - 1; kk++)
   {
      ll = 0;
      mm = 0;
      for(ii = kk; ii <= nn; ii++)
      {
         if(MathAbs(ai[ii][kk]) > mm)
         {
            mm = MathAbs(ai[ii][kk]);
            ll = ii;
         }
      }
      if(ll == 0) return(0);
      
      if(ll != kk)
      {
         for(jj = 1; jj <= nn; jj++)
         {
            tt = ai[kk][jj];
            ai[kk][jj] = ai[ll][jj];
            ai[ll][jj] = tt;
         }
         tt = b[kk];
         b[kk] = b[ll];
         b[ll] = tt;
      }
      
      for(ii = kk + 1; ii <= nn; ii++)
      {
         qq = ai[ii][kk] / ai[kk][kk];
         for(jj = 1; jj <= nn; jj++)
         {
            if(jj == kk) 
               ai[ii][jj] = 0;
            else 
               ai[ii][jj] = ai[ii][jj] - qq * ai[kk][jj];
         }
         b[ii] = b[ii] - qq * b[kk];
      }
   }
   
   //--- Back substitution
   x[nn] = b[nn] / ai[nn][nn];
   for(ii = nn - 1; ii >= 1; ii--)
   {
      tt = 0;
      for(jj = 1; jj <= nn - ii; jj++)
      {
         tt = tt + ai[ii][ii + jj] * x[ii + jj];
         x[ii] = (1 / ai[ii][ii]) * (b[ii] - tt);
      }
   }
   
   //--- Calculate regression line
   for(n = i0; n <= i0 + p; n++)
   {
      sum = 0;
      for(kk = 1; kk <= degree; kk++)
      {
         sum += x[kk + 1] * MathPow(n, kk);
      }
      fx[n] = x[1] + sum;
   }
   
   //--- Calculate standard deviation bands
   sq = 0.0;
   for(n = i0; n <= i0 + p; n++)
   {
      sq += MathPow(close[n] - fx[n], 2);
   }
   sq = MathSqrt(sq / (p + 1)) * kstd;
   
   //--- Calculate upper and lower channels
   for(n = i0; n <= i0 + p; n++)
   {
      sqh[n] = fx[n] + sq;
      sql[n] = fx[n] - sq;
   }
   
   //--- Return value of prev_calculated for next call
   return(rates_total);
}
//+------------------------------------------------------------------+