
#property copyright ""
#property link      ""

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Magenta
#property indicator_color2 Aqua
#property indicator_color3 Red
#property indicator_color4 Yellow

extern int     NumberOfBars = 300;
extern double  Offset = 5;

double R[],D[],S[],W[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
     Offset = Offset*Point;
     
      SetIndexBuffer(0,R);
      SetIndexStyle(0,DRAW_ARROW,0,2);
      SetIndexArrow(0, 119);
      SetIndexLabel(0,"Reversal");
      
      SetIndexBuffer(1,D);
      SetIndexStyle(1,DRAW_ARROW,0,0);
      SetIndexArrow(1, 233);
      SetIndexLabel(1,"Demand");
      
      SetIndexBuffer(2,S);
      SetIndexStyle(2,DRAW_ARROW,0,0);
      SetIndexArrow(2,234);
      SetIndexLabel(2,"Supply");
      
      SetIndexBuffer(3,W);
      SetIndexStyle(3,DRAW_ARROW,0,1);
      SetIndexArrow(3, 251);
      SetIndexLabel(3,"Warning");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   
   double spd1,spd2,v1,v2;
   int limit;
   int counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=NumberOfBars; //Bars-counted_bars;

   for(int i=limit; i>=0; i--)   
      {
         spd1 = High[i+1] - Low[i+1];
         spd2 = High[i+2] - Low[i+2];
         
         R[i]=0; D[i]=0; S[i]=0; W[i]=0;
         
         v1=iVolume(NULL,0,i+1);
         v2=iVolume(NULL,0,i+2);
   
         if ( spd1 > spd2 )
            {
               if ( v1 < v2 )
                  {
                     if ( High[i+1]-Close[i+1] < Close[i+1]-Low[i+1] )
                        {
                           R[i+1] = High[i+1] + Offset;
                           S[i+1] = 0;
                        }   
                     if ( High[i+1]-Close[i+1] > Close[i+1]-Low[i+1] )
                        {
                           R[i+1] = Low[i+1] - Offset;
                           D[i+1] = 0;
                        }
                  }           
               if ( v1 > v2 )
                  {
                     if ( High[i+1]-Close[i+1] < Close[i+1]-Low[i+1] )
                        {
                           D[i+1] = Low[i+1] - Offset;
                           R[i+1] = 0;
                        }            
                     if ( High[i+1]-Close[i+1] > Close[i+1]-Low[i+1] )
                        {
                           S[i+1] = High[i+1] + Offset;
                           R[i+1] = 0;
                        }   
                  }      
            }
                        
         if ( spd1 < spd2 )
            
               if ( v1 > v2 )
                  W[i+1] = High[i+1] + Offset;            
      }
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+