//+------------------------------------------------------------------+
//|                                             ZigAndZagScalpel.mq5 |
//|                           Bookkeeper, 2006, yuzefovich@gmail.com |
//|                                      Converted to MT5 by Jackie  |
//|                                      https://forexsynthetics.com |
//+------------------------------------------------------------------+
#property copyright "Converted to MT5 by Jackie"
#property link      "https://forexsynthetics.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 7
#property indicator_plots   4

//--- Plot settings
#property indicator_label1  "ZigZag Line"
#property indicator_type1   DRAW_SECTION
#property indicator_color1  clrAqua
#property indicator_style1  STYLE_DOT
#property indicator_width1  1

#property indicator_label2  "Limit Orders"
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrWhite
#property indicator_style2  STYLE_SOLID
#property indicator_width2  2

#property indicator_label3  "Buy Signals"
#property indicator_type3   DRAW_ARROW
#property indicator_color3  clrRed
#property indicator_style3  STYLE_SOLID
#property indicator_width3  2

#property indicator_label4  "Sell Signals"
#property indicator_type4   DRAW_ARROW
#property indicator_color4  clrRed
#property indicator_style4  STYLE_SOLID
#property indicator_width4  2

//--- Input parameters
input int KeelOver = 55;  // KeelOver Period (for M15)
input int Slalom   = 17;  // Slalom Period (for M15)

//--- Indicator buffers
double KeelOverZigAndZagSECTION[];
double KeelOverZagBuffer[];
double SlalomZigBuffer[];
double SlalomZagBuffer[];
double LimitOrdersBuffer[];
double BuyOrdersBuffer[];
double SellOrdersBuffer[];

//--- Global variables
int    shift, back, CountBar, Backstep = 3;
int    LastSlalomZagPos, LastSlalomZigPos, LastKeelOverZagPos, LastKeelOverZigPos;
double Something, LimitPoints, Navel;
double CurKeelOverZig, CurKeelOverZag, CurSlalomZig, CurSlalomZag;
double LastSlalomZag, LastSlalomZig, LastKeelOverZag, LastKeelOverZig;
bool   TrendUp, SetBuyOrder, SetLimitOrder, SetSellOrder, Second = false;
string LastZigOrZag = "None";

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
   //--- Indicator buffers mapping
   SetIndexBuffer(0, KeelOverZigAndZagSECTION, INDICATOR_DATA);
   SetIndexBuffer(1, KeelOverZagBuffer, INDICATOR_CALCULATIONS);
   SetIndexBuffer(2, SlalomZigBuffer, INDICATOR_CALCULATIONS);
   SetIndexBuffer(3, SlalomZagBuffer, INDICATOR_CALCULATIONS);
   SetIndexBuffer(4, LimitOrdersBuffer, INDICATOR_DATA);
   SetIndexBuffer(5, BuyOrdersBuffer, INDICATOR_DATA);
   SetIndexBuffer(6, SellOrdersBuffer, INDICATOR_DATA);
   
   //--- Set arrow codes
   PlotIndexSetInteger(1, PLOT_ARROW, 108);
   PlotIndexSetInteger(2, PLOT_ARROW, 233);
   PlotIndexSetInteger(3, PLOT_ARROW, 234);
   
   //--- Set empty values
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, 0.0);
   
   //--- Set indicator short name
   string short_name = StringFormat("ZigZag Scalpel(%d,%d)", KeelOver, Slalom);
   IndicatorSetString(INDICATOR_SHORTNAME, short_name);
   
   //--- Set digits
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);
   
   //--- Set arrays as series
   ArraySetAsSeries(KeelOverZigAndZagSECTION, true);
   ArraySetAsSeries(KeelOverZagBuffer, true);
   ArraySetAsSeries(SlalomZigBuffer, true);
   ArraySetAsSeries(SlalomZagBuffer, true);
   ArraySetAsSeries(LimitOrdersBuffer, true);
   ArraySetAsSeries(BuyOrdersBuffer, true);
   ArraySetAsSeries(SellOrdersBuffer, true);
   
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   if(rates_total < KeelOver) return(0);
   
   //--- Set arrays as series
   ArraySetAsSeries(open, true);
   ArraySetAsSeries(high, true);
   ArraySetAsSeries(low, true);
   ArraySetAsSeries(close, true);
   
   CountBar = rates_total - KeelOver;
   LimitPoints = SymbolInfoDouble(_Symbol, SYMBOL_ASK) - SymbolInfoDouble(_Symbol, SYMBOL_BID);
   
   if(CountBar <= 3 * KeelOver) return(0);
   if(KeelOver <= 2 * Slalom) return(0);
   
   //--- Clear incorrect history
   for(shift = rates_total - 1; shift > rates_total - KeelOver; shift--)
   {
      SlalomZagBuffer[shift] = 0.0;
      SlalomZigBuffer[shift] = 0.0;
      KeelOverZagBuffer[shift] = 0.0;
      KeelOverZigAndZagSECTION[shift] = 0.0;
      LimitOrdersBuffer[shift] = 0.0;
      BuyOrdersBuffer[shift] = 0.0;
      SellOrdersBuffer[shift] = 0.0;
   }
   
   //--- First pass through history
   The_First_Crusade(high, low, close);
   
   //--- Second pass to clean up misunderstood events
   LastSlalomZag = -1; LastSlalomZagPos = -1;
   LastSlalomZig = -1; LastSlalomZigPos = -1;
   LastKeelOverZag = -1; LastKeelOverZagPos = -1;
   LastKeelOverZig = -1; LastKeelOverZigPos = -1;
   The_Second_Crusade();
   
   //--- Third pass - build trend and place trade signals
   LastSlalomZag = -1; LastSlalomZagPos = -1;
   LastSlalomZig = -1; LastSlalomZigPos = -1;
   LastZigOrZag = "None";
   The_Third_Crusade(open, high, low, close);
   
   //--- Calculate current bar
   Shift_Zerro(open, high, low, close);
   
   return(rates_total);
}

//+------------------------------------------------------------------+
//| First Crusade - Find ZigZag points                              |
//+------------------------------------------------------------------+
void The_First_Crusade(const double &high[], const double &low[], const double &close[])
{
   for(shift = CountBar; shift > 0; shift--)
   {
      // Search for Slalom Zig and Zag points
      CurSlalomZig = low[ArrayMinimum(low, shift, Slalom)];
      CurSlalomZag = high[ArrayMaximum(high, shift, Slalom)];
      
      // Check for Slalom Zig
      if(CurSlalomZig == LastSlalomZig) 
         CurSlalomZig = 0.0;
      else
      {
         LastSlalomZig = CurSlalomZig;
         if((low[shift] - CurSlalomZig) > LimitPoints) 
            CurSlalomZig = 0.0;
         else
         {
            // Only one Zig can exist in Backstep interval
            for(back = 1; back <= Backstep; back++)
            {
               Something = SlalomZigBuffer[shift + back];
               if((Something != 0) && (Something > CurSlalomZig))
                  SlalomZigBuffer[shift + back] = 0.0;
            }
         }
      }
      
      // Check for Slalom Zag
      if(CurSlalomZag == LastSlalomZag) 
         CurSlalomZag = 0.0;
      else
      {
         LastSlalomZag = CurSlalomZag;
         if((CurSlalomZag - high[shift]) > LimitPoints) 
            CurSlalomZag = 0.0;
         else
         {
            // Only one Zag can exist in Backstep interval
            for(back = 1; back <= Backstep; back++)
            {
               Something = SlalomZagBuffer[shift + back];
               if((Something != 0) && (Something < CurSlalomZag))
                  SlalomZagBuffer[shift + back] = 0.0;
            }
         }
      }
      
      // Store in Slalom buffers
      SlalomZigBuffer[shift] = CurSlalomZig;
      SlalomZagBuffer[shift] = CurSlalomZag;
      
      // Search for KeelOver reversal points
      CurKeelOverZig = low[ArrayMinimum(low, shift, KeelOver)];
      CurKeelOverZag = high[ArrayMaximum(high, shift, KeelOver)];
      
      // Check for KeelOver Zig
      if(CurKeelOverZig == LastKeelOverZig) 
         CurKeelOverZig = 0.0;
      else
      {
         LastKeelOverZig = CurKeelOverZig;
         if((low[shift] - CurKeelOverZig) > LimitPoints) 
            CurKeelOverZig = 0.0;
         else
         {
            for(back = 1; back <= Backstep; back++)
            {
               Something = KeelOverZigAndZagSECTION[shift + back];
               if((Something != 0) && (Something > CurKeelOverZig))
                  KeelOverZigAndZagSECTION[shift + back] = 0.0;
            }
         }
      }
      
      // Check for KeelOver Zag
      if(CurKeelOverZag == LastKeelOverZag) 
         CurKeelOverZag = 0.0;
      else
      {
         LastKeelOverZag = CurKeelOverZag;
         if((CurKeelOverZag - high[shift]) > LimitPoints) 
            CurKeelOverZag = 0.0;
         else
         {
            for(back = 1; back <= Backstep; back++)
            {
               Something = KeelOverZagBuffer[shift + back];
               if((Something != 0) && (Something < CurKeelOverZag))
                  KeelOverZagBuffer[shift + back] = 0.0;
            }
         }
      }
      
      // Store in KeelOver buffers
      KeelOverZigAndZagSECTION[shift] = CurKeelOverZig;
      KeelOverZagBuffer[shift] = CurKeelOverZag;
   }
}

//+------------------------------------------------------------------+
//| Second Crusade - Clean up excess points                         |
//+------------------------------------------------------------------+
void The_Second_Crusade()
{
   for(shift = CountBar; shift > 0; shift--)
   {
      CurSlalomZig = SlalomZigBuffer[shift];
      CurSlalomZag = SlalomZagBuffer[shift];
      
      if((CurSlalomZig == 0) && (CurSlalomZag == 0)) continue;
      
      if(CurSlalomZag != 0)
      {
         if(LastSlalomZag > 0)
         {
            if(LastSlalomZag < CurSlalomZag) 
               SlalomZagBuffer[LastSlalomZagPos] = 0;
            else 
               SlalomZagBuffer[shift] = 0;
         }
         if(LastSlalomZag < CurSlalomZag || LastSlalomZag < 0)
         {
            LastSlalomZag = CurSlalomZag;
            LastSlalomZagPos = shift;
         }
         LastSlalomZig = -1;
      }
      
      if(CurSlalomZig != 0)
      {
         if(LastSlalomZig > 0)
         {
            if(LastSlalomZig > CurSlalomZig) 
               SlalomZigBuffer[LastSlalomZigPos] = 0;
            else 
               SlalomZigBuffer[shift] = 0;
         }
         if((CurSlalomZig < LastSlalomZig) || (LastSlalomZig < 0))
         {
            LastSlalomZig = CurSlalomZig;
            LastSlalomZigPos = shift;
         }
         LastSlalomZag = -1;
      }
      
      CurKeelOverZig = KeelOverZigAndZagSECTION[shift];
      CurKeelOverZag = KeelOverZagBuffer[shift];
      
      if((CurKeelOverZig == 0) && (CurKeelOverZag == 0)) continue;
      
      if(CurKeelOverZag != 0)
      {
         if(LastKeelOverZag > 0)
         {
            if(LastKeelOverZag < CurKeelOverZag)
               KeelOverZagBuffer[LastKeelOverZagPos] = 0;
            else 
               KeelOverZagBuffer[shift] = 0.0;
         }
         if(LastKeelOverZag < CurKeelOverZag || LastKeelOverZag < 0)
         {
            LastKeelOverZag = CurKeelOverZag;
            LastKeelOverZagPos = shift;
         }
         LastKeelOverZig = -1;
      }
      
      if(CurKeelOverZig != 0)
      {
         if(LastKeelOverZig > 0)
         {
            if(LastKeelOverZig > CurSlalomZig)
               KeelOverZigAndZagSECTION[LastKeelOverZigPos] = 0;
            else 
               KeelOverZigAndZagSECTION[shift] = 0;
         }
         if((CurKeelOverZig < LastKeelOverZig) || (LastKeelOverZig < 0))
         {
            LastKeelOverZig = CurKeelOverZig;
            LastKeelOverZigPos = shift;
         }
         LastKeelOverZag = -1;
      }
   }
}

//+------------------------------------------------------------------+
//| Third Crusade - Build trend and place trade signals             |
//+------------------------------------------------------------------+
void The_Third_Crusade(const double &open[], const double &high[], 
                       const double &low[], const double &close[])
{
   bool first = true;
   
   for(shift = CountBar; shift > 0; shift--)
   {
      // Clear previous signals
      LimitOrdersBuffer[shift] = 0.0;
      BuyOrdersBuffer[shift] = 0.0;
      SellOrdersBuffer[shift] = 0.0;
      
      // Calculate center of the bar
      Navel = (5 * close[shift] + 2 * open[shift] + high[shift] + low[shift]) / 9;
      
      // Determine trend direction
      if(KeelOverZigAndZagSECTION[shift] != 0.0)
      {
         TrendUp = true;
         first = false;
      }
      if(KeelOverZagBuffer[shift] != 0.0)
      {
         TrendUp = false;
         first = false;
      }
      
      // Build ZigZag line
      if(KeelOverZagBuffer[shift] != 0.0 || KeelOverZigAndZagSECTION[shift] != 0.0)
      {
         KeelOverZigAndZagSECTION[shift] = Navel;
      }
      else 
         KeelOverZigAndZagSECTION[shift] = 0.0;
      
      // Check for Slalom Zig or Zag
      if(SlalomZigBuffer[shift] != 0.0)
      {
         LastZigOrZag = "Zig";
         LastSlalomZig = Navel;
         SetBuyOrder = false;
         SetLimitOrder = false;
         SetSellOrder = false;
      }
      if(SlalomZagBuffer[shift] != 0.0)
      {
         LastZigOrZag = "Zag";
         LastSlalomZag = Navel;
         SetBuyOrder = false;
         SetLimitOrder = false;
         SetSellOrder = false;
      }
      
      // Check for trade signals
      if(SlalomZigBuffer[shift] == 0.0 &&
         SlalomZagBuffer[shift] == 0.0 &&
         first == false)
         Slalom_With_A_Scalpel(high, low);
   }
}

//+------------------------------------------------------------------+
//| Calculate current bar                                           |
//+------------------------------------------------------------------+
void Shift_Zerro(const double &open[], const double &high[], 
                 const double &low[], const double &close[])
{
   shift = 0;
   Navel = (5 * close[0] + 2 * open[0] + high[0] + low[0]) / 9;
   Slalom_With_A_Scalpel(high, low);
   KeelOverZigAndZagSECTION[0] = Navel;
}

//+------------------------------------------------------------------+
//| Place trade signals based on trend and Slalom points            |
//+------------------------------------------------------------------+
void Slalom_With_A_Scalpel(const double &high[], const double &low[])
{
   if(LastZigOrZag == "Zig")
   {
      if(TrendUp == true)
      {
         if((Navel - LastSlalomZig) >= LimitPoints && SetBuyOrder == false)
         {
            SetBuyOrder = true;
            BuyOrdersBuffer[shift] = low[shift + 1];
            LastSlalomZigPos = shift;
         }
         if(Navel <= LastSlalomZig && SetBuyOrder == true)
         {
            SetBuyOrder = false;
            BuyOrdersBuffer[LastSlalomZigPos] = 0.0;
            LastSlalomZigPos = -1;
         }
      }
      if(TrendUp == false)
      {
         if(Navel > LastSlalomZig && SetLimitOrder == false)
         {
            SetLimitOrder = true;
            LimitOrdersBuffer[shift] = Navel;
            LastSlalomZigPos = shift;
         }
         if(Navel <= LastSlalomZig && SetLimitOrder == true)
         {
            SetLimitOrder = false;
            LimitOrdersBuffer[LastSlalomZigPos] = 0.0;
            LastSlalomZigPos = -1;
         }
      }
   }
   
   if(LastZigOrZag == "Zag")
   {
      if(TrendUp == false)
      {
         if((LastSlalomZag - Navel) >= LimitPoints && SetSellOrder == false)
         {
            SetSellOrder = true;
            SellOrdersBuffer[shift] = high[shift + 1];
            LastSlalomZagPos = shift;
         }
         if(Navel >= LastSlalomZag && SetSellOrder == true)
         {
            SetSellOrder = false;
            SellOrdersBuffer[LastSlalomZagPos] = 0.0;
            LastSlalomZagPos = -1;
         }
      }
      if(TrendUp == true)
      {
         if(LastSlalomZag > Navel && SetLimitOrder == false)
         {
            SetLimitOrder = true;
            LimitOrdersBuffer[shift] = Navel;
            LastSlalomZagPos = shift;
         }
         if(Navel >= LastSlalomZag && SetLimitOrder == true)
         {
            SetLimitOrder = false;
            LimitOrdersBuffer[LastSlalomZagPos] = 0.0;
            LastSlalomZagPos = -1;
         }
      }
   }
}
//+------------------------------------------------------------------+